/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.Util;
import com.install4j.api.beans.Bean;
import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.formcomponents.ComponentTuple;
import com.install4j.api.formcomponents.FormComponent;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.Console;
import com.install4j.api.screens.FormPanelContainer;
import com.install4j.api.screens.Screen;
import com.install4j.api.styles.Style;
import com.install4j.runtime.beans.AnchorUtil;
import com.install4j.runtime.beans.formcomponents.CompoundComponentHandler;
import com.install4j.runtime.beans.formcomponents.FormEnvironmentImpl;
import com.install4j.runtime.beans.groups.FormComponentGroup;
import com.install4j.runtime.beans.groups.GroupOrientation;
import com.install4j.runtime.beans.groups.HorizontalFormComponentGroup;
import com.install4j.runtime.beans.groups.LayoutManagerGroup;
import com.install4j.runtime.beans.groups.TabGroup;
import com.install4j.runtime.beans.groups.VerticalFormComponentGroup;
import com.install4j.runtime.beans.screens.components.ScrollablePanel;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.config.FormComponentBeanConfig;
import com.install4j.runtime.installer.config.FormComponentProvider;
import com.install4j.runtime.installer.config.GroupProvider;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.StyleBeanConfig;
import com.install4j.runtime.installer.frontend.ComponentTupleImpl;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.LayoutGroupImpl;
import com.install4j.runtime.installer.frontend.ScreenEnvelope;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.util.ComponentsScrollPane;
import com.install4j.runtime.util.CustomPanel;
import com.install4j.runtime.util.SizeGroupComponentWrapper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.UIResource;

public class FormPanel
extends CustomPanel {
    private List<?> beanConfigs;
    private List<FormComponentProvider> formComponentProviders;
    private Map<String, Bean> idToReplacedBean = new HashMap<String, Bean>();
    private Context context;
    private Bean parentComponent;
    private ScreenEnvelope screenEnvelope;
    private ComponentsScrollPane scpComponents;
    protected JPanel componentsPanel;
    private Set<FormComponent> initializedComponents = new HashSet<FormComponent>();
    private FormEnvironment formEnvironment;

    public FormPanel(List<?> beanConfigs, Context context, Bean parentComponent, ScreenEnvelope screenEnvelope, Map<String, Bean> idToReplacedBean) {
        this.beanConfigs = beanConfigs;
        this.context = context;
        this.parentComponent = parentComponent;
        this.screenEnvelope = screenEnvelope;
        if (idToReplacedBean != null) {
            this.idToReplacedBean.putAll(idToReplacedBean);
        }
        if (this.isAutoInit()) {
            this.init();
        }
    }

    protected boolean isAutoInit() {
        return true;
    }

    protected void init() {
        this.setupControls();
        this.setupComponent();
    }

    public Context getContext() {
        return this.context;
    }

    public FormEnvironment getFormEnvironment() {
        return this.formEnvironment;
    }

    public ScreenEnvelope getScreenEnvelope() {
        return this.screenEnvelope;
    }

    public Screen getScreen() {
        if (this.screenEnvelope != null) {
            return this.screenEnvelope.getScreen();
        }
        return this.parentComponent instanceof Screen ? (Screen)this.parentComponent : null;
    }

    public ProgressInterface findProgressInterface() {
        for (FormComponentProvider formComponentProvider : this.formComponentProviders) {
            FormComponent formComponent = this.getBean(formComponentProvider);
            if (!(formComponent instanceof ProgressInterface) || !formComponent.isEnabled()) continue;
            return (ProgressInterface)((Object)formComponent);
        }
        return null;
    }

    public void reinitializeComponents() {
        this.initializedComponents.clear();
        this.initializeComponents();
    }

    public void previous() {
        for (FormComponentProvider config : this.formComponentProviders) {
            if (!config.isResetInitOnPrevious()) continue;
            this.initializedComponents.remove(this.getBean(config));
        }
    }

    public boolean checkCompleted() {
        for (FormComponentProvider config : this.formComponentProviders) {
            FormComponent formComponent = this.getBean(config);
            if (!formComponent.isVisible() || formComponent.checkCompleted()) continue;
            return false;
        }
        return true;
    }

    public void willActivate() {
        this.initializeComponents();
        for (FormComponentProvider config : this.formComponentProviders) {
            this.getBean(config).formWillActivate();
        }
    }

    public void activated() {
        for (FormComponentProvider config : this.formComponentProviders) {
            this.getBean(config).formActivated();
        }
    }

    public void deactivated() {
        for (FormComponentProvider config : this.formComponentProviders) {
            this.getBean(config).formDeactivated();
        }
    }

    public boolean handleUnattended() {
        this.initializeComponents();
        for (FormComponentProvider config : this.formComponentProviders) {
            FormComponent formComponent = this.processFormComponent(config);
            if (formComponent == null || formComponent.handleUnattended()) continue;
            return false;
        }
        return this.checkCompleted();
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        if (this.parentComponent instanceof Screen) {
            ((Screen)this.parentComponent).willActivate();
        }
        this.willActivate();
        if (this.parentComponent instanceof Screen) {
            ((Screen)this.parentComponent).activated();
        }
        this.activated();
        this.enableLayoutGroups(this.beanConfigs);
        do {
            for (FormComponentProvider config : this.formComponentProviders) {
                FormComponent formComponent = this.processFormComponent(config);
                if (formComponent == null || formComponent.handleConsole(console)) continue;
                this.deactivated();
                return false;
            }
        } while (!this.checkCompleted());
        this.deactivated();
        return true;
    }

    private boolean isInHiddenLayoutGroup(FormComponent formComponent) {
        return this.isInHiddenLayoutGroup(formComponent, this.beanConfigs);
    }

    private boolean isInHiddenLayoutGroup(FormComponent formComponent, List<?> beanConfigs) {
        for (Object bean : beanConfigs) {
            GroupProvider groupProvider;
            if (!(bean instanceof GroupProvider ? this.getBean(groupProvider = (GroupProvider)bean).isVisible() && !this.isInHiddenLayoutGroup(formComponent, groupProvider.getBeanConfigs()) : bean instanceof FormComponentProvider && this.getBean((FormComponentProvider)bean) == formComponent)) continue;
            return false;
        }
        return true;
    }

    private void enableLayoutGroups(List<?> beanConfigs) {
        for (Object bean : beanConfigs) {
            if (!(bean instanceof GroupProvider)) continue;
            GroupProvider groupProvider = (GroupProvider)bean;
            FormComponentGroup group = this.getBean(groupProvider);
            try {
                Boolean visible = (Boolean)this.context.runScript(group.getVisibilityScript(), group, this.formEnvironment);
                if (visible != null) {
                    group.setVisible(visible);
                }
                this.enableLayoutGroups(groupProvider.getBeanConfigs());
            }
            catch (Exception e) {
                Util.printAnnotatedStackTrace(e);
                Logger.getInstance().log(e);
                return;
            }
        }
    }

    private FormComponent processFormComponent(FormComponentProvider config) {
        FormComponent formComponent = this.getBean(config);
        if (this.isInHiddenLayoutGroup(formComponent)) {
            return null;
        }
        Object[] parameters = formComponent.getConfigurationObjectClass() != null ? new Object[]{this.formEnvironment, formComponent.getConfigurationObject()} : new Object[]{this.formEnvironment};
        String visibilityClassName = ((FormComponentBeanConfig)config).getVisibilityClassName();
        if (visibilityClassName != null && !visibilityClassName.isEmpty()) {
            formComponent.setVisible(ContextImpl.getContextInt(this.context).runBooleanScript(visibilityClassName, formComponent, parameters));
        }
        if (!(formComponent instanceof CompoundComponentHandler || formComponent.isVisible() && formComponent.isEnabled())) {
            return null;
        }
        return formComponent;
    }

    protected void initializeComponents() {
        this.enableLayoutGroups(this.beanConfigs);
        for (FormComponentProvider config : this.formComponentProviders) {
            FormComponent formComponent = this.getBean(config);
            if (this.initializedComponents.contains(formComponent)) continue;
            this.initializeComponent(formComponent, config);
            this.initializedComponents.add(formComponent);
        }
    }

    protected void initializeComponent(FormComponent formComponent, FormComponentProvider config) {
        try {
            formComponent.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.getInstance().log(e);
        }
        Object[] parameters = formComponent.getConfigurationObjectClass() != null ? new Object[]{this.formEnvironment, formComponent.getConfigurationObject()} : new Object[]{this.formEnvironment};
        ContextInt contextInt = ContextImpl.getContextInt(this.context);
        if (contextInt != null) {
            try {
                formComponent.setVisible(contextInt.runBooleanScript(((FormComponentBeanConfig)config).getVisibilityClassName(), formComponent, parameters));
            }
            catch (Exception e) {
                e.printStackTrace();
                Logger.getInstance().log(e);
            }
            try {
                contextInt.runBooleanScript(((FormComponentBeanConfig)config).getInitClassName(), formComponent, parameters);
            }
            catch (Exception e) {
                e.printStackTrace();
                Logger.getInstance().log(e);
            }
        }
    }

    private void setupControls() {
        this.componentsPanel = new ScrollablePanel();
        this.componentsPanel.setLayout(new GridBagLayout());
        this.scpComponents = new ComponentsScrollPane(this.componentsPanel);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private void setupComponent() {
        this.setLayout(new BorderLayout());
        this.formEnvironment = this.createFormEnvironment(new FormComponent[0], new String[0], new String[0], new ComponentTuple[0], Collections.emptyList(), false);
        ArrayList<FormComponent> formComponentsList = new ArrayList<FormComponent>();
        ArrayList<String> idsList = new ArrayList<String>();
        ArrayList<String> displayedIdsList = new ArrayList<String>();
        ArrayList<ComponentTuple> componentTuplesList = new ArrayList<ComponentTuple>();
        this.formComponentProviders = new ArrayList<FormComponentProvider>();
        PanelConstructionState panelConstructionState = this.buildPanel(this.beanConfigs, this.componentsPanel, new VerticalFormComponentGroup(), formComponentsList, idsList, displayedIdsList, componentTuplesList, false, null);
        FormComponent[] formComponents = formComponentsList.toArray(new FormComponent[0]);
        String[] ids = idsList.toArray(new String[0]);
        String[] displayedIds = displayedIdsList.toArray(new String[idsList.size()]);
        ComponentTuple[] componentTuples = componentTuplesList.toArray(new ComponentTuple[0]);
        this.formEnvironment = this.createFormEnvironment(formComponents, ids, displayedIds, componentTuples, this.beanConfigs, true);
        this.setFormEnvironment(this.formEnvironment.getFormComponentTree());
        if (this.parentComponent != null) {
            if (this.parentComponent instanceof FormPanelContainer && ((FormPanelContainer)((Object)this.parentComponent)).isScrollFormPanel()) {
                this.add((Component)this.scpComponents, "Center");
            } else {
                if (!panelConstructionState.verticalSpaceFilled && this.isFillVertical(this.parentComponent)) {
                    GridBagConstraints gc = panelConstructionState.gc;
                    gc.gridx = 0;
                    gc.weighty = 1.0;
                    gc.fill = 3;
                    CustomPanel spacerPanel = new CustomPanel();
                    spacerPanel.setPreferredSize(new Dimension(100, 0));
                    this.componentsPanel.add((Component)spacerPanel, gc);
                    ++gc.gridy;
                }
                this.add((Component)this.componentsPanel, "Center");
            }
        }
        this.componentsPanel.setOpaque(false);
        this.setOpaque(false);
    }

    private boolean isFillVertical(Bean parentComponent) {
        if (parentComponent instanceof Style) {
            return ((Style)parentComponent).isFillVertical();
        }
        return true;
    }

    private void setFormEnvironment(List<?> components) {
        for (Object bean : components) {
            if (bean instanceof FormComponent) {
                ((FormComponent)bean).setFormEnvironment(this.formEnvironment);
                continue;
            }
            if (!(bean instanceof LayoutGroupImpl)) continue;
            LayoutGroupImpl layoutGroup = (LayoutGroupImpl)bean;
            layoutGroup.getGroup().setFormEnvironment(this.formEnvironment);
            this.setFormEnvironment(layoutGroup.getChildren());
        }
    }

    private PanelConstructionState buildPanel(List<?> beanConfigs, JComponent container, FormComponentGroup parentGroup, List<FormComponent> formComponentsList, List<String> idsList, List<String> displayedIdsList, List<ComponentTuple> componentTuplesList, boolean baseLineOverride, Color foregroundColor) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        boolean verticalSpaceFilled = false;
        boolean horizontalSpaceFilled = false;
        boolean first = true;
        SizeGroupComponentWrapper firstSizeGroupComponentWrapper = null;
        for (Object bean : beanConfigs) {
            Object config;
            if (bean instanceof FormComponentProvider && parentGroup instanceof LayoutManagerGroup) {
                config = (FormComponentProvider)bean;
                FormComponent formComponent = this.getBean((FormComponentProvider)config);
                formComponent.setContext(config.wrapContext(this.context));
                formComponent.setFormEnvironment(this.formEnvironment);
                if (!config.isEnabled()) continue;
                this.formComponentProviders.add((FormComponentProvider)config);
                verticalSpaceFilled |= formComponent.isFillCenterVertical();
                horizontalSpaceFilled |= formComponent.isFillCenterHorizontal();
                ComponentTuple componentTuple = this.addFormComponent((FormComponentProvider)config, (JPanel)container, gc, (LayoutManagerGroup)parentGroup, baseLineOverride, first);
                if (first && componentTuple.getLeftComponent() != null) {
                    firstSizeGroupComponentWrapper = (SizeGroupComponentWrapper)componentTuple.getLeftComponent().getParent();
                }
                formComponentsList.add(formComponent);
                idsList.add(this.dequalifyId(config.getId()));
                displayedIdsList.add(this.dequalifyId(config.getDisplayedId()));
                componentTuplesList.add(componentTuple);
                this.adjustColors(componentTuple.getLeftComponent(), foregroundColor);
                this.adjustColors(componentTuple.getCenterComponent(), foregroundColor);
                this.adjustColors(componentTuple.getRightComponent(), foregroundColor);
            } else if (bean instanceof GroupProvider) {
                Color groupForegroundColor;
                config = (GroupProvider)bean;
                if (!config.isEnabled()) continue;
                FormComponentGroup group = this.getBean((GroupProvider)config);
                group.setFormEnvironment(this.formEnvironment);
                group.setContext(this.context);
                group.setId(config.getId());
                JComponent childContainer = group.createComponent(container);
                if (group instanceof LayoutManagerGroup && (groupForegroundColor = ((LayoutManagerGroup)group).getForegroundColor()) != null) {
                    foregroundColor = groupForegroundColor;
                    childContainer.setForeground(groupForegroundColor);
                }
                PanelConstructionState panelConstructionState = this.buildPanel(config.getBeanConfigs(), childContainer, group, formComponentsList, idsList, displayedIdsList, componentTuplesList, group.isBaselineOverride(), foregroundColor);
                verticalSpaceFilled |= panelConstructionState.verticalSpaceFilled;
                horizontalSpaceFilled |= panelConstructionState.horizontalSpaceFilled;
                if (group instanceof TabGroup) {
                    this.addTabGroup((TabGroup)group, childContainer, panelConstructionState);
                } else {
                    GroupOrientation parentGroupOrientation = parentGroup.getGroupOrientation();
                    if (parentGroupOrientation == GroupOrientation.VERTICAL) {
                        gc.gridx = 0;
                        gc.gridwidth = 3;
                    } else {
                        gc.gridwidth = 1;
                    }
                    if (parentGroup instanceof VerticalFormComponentGroup && group instanceof HorizontalFormComponentGroup && ((HorizontalFormComponentGroup)group).isAlignFirstLabel() && panelConstructionState.firstSizeGroupComponentWrapper != null) {
                        ((VerticalFormComponentGroup)parentGroup).getSizeGroup().addComponentWrapper(panelConstructionState.firstSizeGroupComponentWrapper);
                    }
                    horizontalSpaceFilled |= group.isWidthOverride();
                    verticalSpaceFilled |= group.isHeightOverride();
                    boolean groupHorizontalSpaceFilled = panelConstructionState.horizontalSpaceFilled || group.isWidthOverride();
                    boolean groupVerticalSpaceFilled = panelConstructionState.verticalSpaceFilled || group.isHeightOverride();
                    gc.anchor = group.getAnchor().getValue();
                    gc.weightx = groupHorizontalSpaceFilled ? 1.0 : 0.0;
                    gc.weighty = groupVerticalSpaceFilled ? 1.0 : 0.0;
                    gc.fill = this.getFillMode(groupHorizontalSpaceFilled, groupVerticalSpaceFilled);
                    gc.insets = new Insets(0, 0, 0, 0);
                    if (group instanceof LayoutManagerGroup) {
                        LayoutManagerGroup layoutManagerGroup = (LayoutManagerGroup)group;
                        container.add((Component)layoutManagerGroup.wrap(childContainer), gc);
                    } else {
                        container.add((Component)childContainer, gc);
                    }
                    ++gc.gridx;
                    if (parentGroupOrientation == GroupOrientation.VERTICAL) {
                        ++gc.gridy;
                    }
                }
            }
            first = false;
        }
        return new PanelConstructionState(gc, verticalSpaceFilled, horizontalSpaceFilled, firstSizeGroupComponentWrapper);
    }

    private void adjustColors(JComponent component, Color foregroundColor) {
        if (component != null) {
            GUIHelper.makeTransparent(component);
            if (foregroundColor != null && component.getForeground() instanceof UIResource) {
                component.setForeground(foregroundColor);
            }
        }
    }

    private void addTabGroup(TabGroup group, JComponent childContainer, PanelConstructionState panelConstructionState) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = group.getAnchor().getValue();
        gc.fill = this.getFillMode(panelConstructionState.horizontalSpaceFilled, panelConstructionState.verticalSpaceFilled);
        gc.insets = (Insets)group.getInsets().clone();
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        group.getPanel().add((Component)childContainer, gc);
    }

    private String dequalifyId(String id) {
        int index = id.indexOf(58);
        if (index < 0) {
            return id;
        }
        return id.substring(index + 1);
    }

    private int getFillMode(boolean horizontalSpaceFilled, boolean verticalSpaceFilled) {
        if (horizontalSpaceFilled) {
            return verticalSpaceFilled ? 1 : 2;
        }
        return verticalSpaceFilled ? 3 : 0;
    }

    protected FormEnvironmentImpl createFormEnvironment(FormComponent[] formComponents, String[] ids, String[] displayedIds, ComponentTuple[] componentTuples, List<?> beanConfigs, boolean initialized) {
        return new FormEnvironmentImpl(this, formComponents, ids, displayedIds, componentTuples, beanConfigs, initialized);
    }

    private ComponentTuple addFormComponent(FormComponentProvider config, JPanel panel, GridBagConstraints gc, LayoutManagerGroup group, boolean baselineOverride, boolean first) {
        int cellSpacing;
        GroupOrientation orientation = group.getGroupOrientation();
        FormComponent formComponent = this.getBean(config);
        JComponent leftComponent = formComponent.createLeftComponent();
        JComponent centerComponent = formComponent.createCenterComponent();
        JComponent rightComponent = formComponent.createRightComponent();
        if (centerComponent == null) {
            return new ComponentTupleImpl(null, null, null);
        }
        gc.insets.top = config.getInsetTop();
        gc.insets.bottom = config.getInsetBottom();
        gc.insets.left = config.getInsetLeft();
        gc.insets.right = 0;
        int n = cellSpacing = first ? 0 : group.getCellSpacing();
        if (orientation == GroupOrientation.VERTICAL) {
            gc.gridx = 0;
            gc.insets.top += cellSpacing;
        } else {
            gc.insets.left += cellSpacing;
        }
        gc.gridwidth = 1;
        boolean baselineLabel = baselineOverride;
        if (leftComponent != null) {
            if (leftComponent instanceof JLabel && !((JLabel)leftComponent).getText().isEmpty() && !group.isMakeSameHeight()) {
                baselineLabel = true;
            }
            gc.anchor = baselineLabel ? 512 : this.getAnchor(leftComponent);
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            gc.fill = 0;
            SizeGroupComponentWrapper componentWrapper = new SizeGroupComponentWrapper(leftComponent);
            panel.add((Component)componentWrapper, gc);
            if (group instanceof VerticalFormComponentGroup) {
                ((VerticalFormComponentGroup)group).getSizeGroup().addComponentWrapper(componentWrapper);
            }
            ++gc.gridx;
            gc.insets.left = 0;
        } else if (orientation == GroupOrientation.VERTICAL) {
            ++gc.gridwidth;
        }
        if (rightComponent == null) {
            if (orientation == GroupOrientation.VERTICAL) {
                ++gc.gridwidth;
            }
            gc.insets.right = config.getInsetRight();
        }
        boolean heightOverride = false;
        boolean widthOverride = false;
        if (orientation == GroupOrientation.HORIZONTAL) {
            gc.weightx = formComponent.isFillCenterHorizontal() ? 1.0 : 0.0;
            heightOverride = group.isMakeSameHeight();
        } else {
            gc.weightx = 1.0;
        }
        if (orientation == GroupOrientation.VERTICAL) {
            gc.weighty = formComponent.isFillCenterVertical() ? 1.0 : 0.0;
            widthOverride = group.isMakeSameWidth();
        } else {
            gc.weighty = 1.0;
        }
        if (widthOverride) {
            gc.weightx = 1.0;
        }
        gc.fill = this.getFillMode(formComponent.isFillCenterHorizontal() || widthOverride, formComponent.isFillCenterVertical() || heightOverride);
        gc.anchor = baselineLabel ? 512 : this.getAnchor(centerComponent);
        panel.add((Component)centerComponent, gc);
        gc.gridx += gc.gridwidth;
        if (rightComponent != null) {
            gc.gridwidth = 1;
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            gc.fill = 0;
            gc.anchor = baselineLabel ? 512 : this.getAnchor(rightComponent);
            gc.insets.right = config.getInsetRight();
            gc.insets.left = 0;
            panel.add((Component)rightComponent, gc);
            ++gc.gridx;
        }
        if (orientation == GroupOrientation.VERTICAL) {
            ++gc.gridy;
        }
        return new ComponentTupleImpl(leftComponent, centerComponent, rightComponent);
    }

    private int getAnchor(JComponent centerComponent) {
        return AnchorUtil.getAnchor(centerComponent);
    }

    private FormComponent getBean(FormComponentProvider formComponentProvider) {
        return (FormComponent)this.replaceBean(formComponentProvider.getId(), formComponentProvider.getFormComponent());
    }

    private FormComponentGroup getBean(GroupProvider groupProvider) {
        return (FormComponentGroup)this.replaceBean(groupProvider.getId(), groupProvider.getOrInstantiateBean());
    }

    private Bean replaceBean(String id, Bean bean) {
        Bean replacedBean = this.idToReplacedBean.get(id);
        if (replacedBean != null) {
            return replacedBean;
        }
        return bean;
    }

    public String getDefaultWidgetStyleId() {
        if (this.screenEnvelope != null) {
            String styleId = this.screenEnvelope.getStyleId();
            StyleBeanConfig styleConfig = InstallerConfig.getCurrentInstance().getStyleConfigById(styleId);
            if (styleConfig != null) {
                return styleConfig.getWidgetStyleId();
            }
            System.err.println("Style config for ID " + styleId + " not found");
        }
        return null;
    }

    private static class PanelConstructionState {
        private final GridBagConstraints gc;
        private final boolean verticalSpaceFilled;
        private final boolean horizontalSpaceFilled;
        private final SizeGroupComponentWrapper firstSizeGroupComponentWrapper;

        public PanelConstructionState(GridBagConstraints gc, boolean verticalSpaceFilled, boolean horizontalSpaceFilled, SizeGroupComponentWrapper firstSizeGroupComponentWrapper) {
            this.gc = gc;
            this.verticalSpaceFilled = verticalSpaceFilled;
            this.horizontalSpaceFilled = horizontalSpaceFilled;
            this.firstSizeGroupComponentWrapper = firstSizeGroupComponentWrapper;
        }
    }
}

