/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.fileinst;

import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.fileinst.BackupPair;
import com.install4j.runtime.installer.helper.fileinst.FileLogger;
import com.install4j.runtime.installer.helper.fileinst.HelperFileInstallerState;
import com.install4j.runtime.installer.helper.fileinst.InstallFile;
import com.install4j.runtime.installer.helper.fileinst.MainFileInstallerState;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

abstract class FileInstallerState
implements Serializable {
    private transient boolean respondedOverwriteNever = false;
    private transient boolean respondedOverwriteAlways = false;
    protected transient int currentId = 0;
    protected transient int maxId = 0;
    private static FileInstallerState instance;
    private Set<Integer> rolledBackIds = new HashSet<Integer>();

    public static FileInstallerState getInstance() {
        if (instance == null) {
            instance = HelperCommunication.getInstance().isElevatedHelper() ? new HelperFileInstallerState() : new MainFileInstallerState();
        }
        return instance;
    }

    public abstract void setRollbackBarrier();

    public abstract void setLogDir(File var1);

    public abstract void writeLog() throws IOException, UserCanceledException;

    public abstract boolean wasPreviouslyCreated(File var1);

    public abstract boolean hasRollbackFiles();

    public abstract boolean hasUnrollbackedFiles();

    public abstract void addReplacedFile(BackupPair var1);

    public abstract void addCreatedDir(InstallFile var1);

    public abstract void registerCleanupFile(File var1);

    public abstract void registerPreUninstallCommand(File var1, boolean var2, String var3, String[] var4);

    public abstract void addCreatedFile(InstallFile var1, boolean var2);

    public abstract FileLogger getRollbackFileLogger();

    public abstract List<BackupPair> getReplacedFiles();

    public abstract List<File> getCleanupFiles();

    public abstract boolean isCurrentRebootRequired();

    public abstract void setCurrentRebootRequired(boolean var1);

    public abstract void setFileRollbackPerformed(boolean var1);

    public abstract boolean isFileRollbackPerformed();

    protected FileInstallerState() {
    }

    public boolean isRespondedOverwriteNever() {
        return this.respondedOverwriteNever;
    }

    public boolean isRespondedOverwriteAlways() {
        return this.respondedOverwriteAlways;
    }

    public void setRespondedOverwriteNever(boolean respondedOverwriteNever) {
        HelperCommunication.getInstance().runAction(ExecutionContext.ALL, context -> {
            FileInstallerState.getInstance().respondedOverwriteNever = respondedOverwriteNever;
        });
    }

    public void setRespondedOverwriteAlways(boolean respondedOverwriteAlways) {
        HelperCommunication.getInstance().runAction(ExecutionContext.ALL, context -> {
            FileInstallerState.getInstance().respondedOverwriteAlways = respondedOverwriteAlways;
        });
    }

    public void setRollbackIds(int currentId, int maxId) {
        HelperCommunication.getInstance().runAction(ExecutionContext.ALL, context -> {
            FileInstallerState.getInstance().currentId = currentId;
            FileInstallerState.getInstance().maxId = maxId;
        });
    }

    public Set<Integer> getRolledBackIds() {
        return this.rolledBackIds;
    }

    public void addRolledBackId(int id) {
        HelperCommunication.getInstance().runAction(ExecutionContext.ALL, context -> {
            for (int i = id; i <= this.maxId; ++i) {
                FileInstallerState.getInstance().rolledBackIds.add(i);
            }
        });
    }
}

