/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.UiUtil;
import com.install4j.api.beans.AbstractBean;
import com.install4j.runtime.beans.formcomponents.FontStyle;
import com.install4j.runtime.beans.formcomponents.FontType;
import java.awt.Font;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class FontDescriptor
extends AbstractBean {
    private Font font;
    private FontType fontType = FontType.DEFAULT;
    private FontStyle fontStyle = FontStyle.UNCHANGED;
    private int fontSizePercent = 100;

    public Font getFont() {
        return this.replaceWithTextOverride("font", this.font, Font.class);
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public FontType getFontType() {
        return this.replaceWithTextOverride("fontType", this.fontType, FontType.class);
    }

    public void setFontType(FontType fontType) {
        this.fontType = fontType;
    }

    public FontStyle getFontStyle() {
        return this.replaceWithTextOverride("fontStyle", this.fontStyle, FontStyle.class);
    }

    public void setFontStyle(FontStyle fontStyle) {
        this.fontStyle = fontStyle;
    }

    public int getFontSizePercent() {
        return this.replaceWithTextOverride("fontSizePercent", this.fontSizePercent);
    }

    public void setFontSizePercent(int fontSizePercent) {
        this.fontSizePercent = fontSizePercent;
    }

    public void applyFont(JComponent component) {
        Font font = this.getFont(component);
        if (font != null) {
            component.setFont(font);
        }
    }

    @Nullable
    public Font getFont(JComponent component) {
        switch (this.getFontType()) {
            case DERIVED: {
                return FontDescriptor.deriveFont(component.getFont(), this.getFontStyle(), this.getFontSizePercent());
            }
            case CUSTOM: {
                Font font = this.getFont();
                if (font == null) break;
                return FontDescriptor.translateFont(font, component);
            }
        }
        return null;
    }

    public float getScale() {
        switch (this.getFontType()) {
            case DERIVED: {
                return (float)this.getFontSizePercent() / 100.0f;
            }
            case CUSTOM: {
                return UiUtil.getLookAndFeelEnhancer().computeFontScaleFactor(this.getFont());
            }
        }
        return 1.0f;
    }

    private static Font deriveFont(Font font, FontStyle fontStyle, int fontSizePercent) {
        if (fontStyle != FontStyle.UNCHANGED) {
            font = font.deriveFont(fontStyle.getStyle());
        }
        if (fontSizePercent != 100) {
            font = font.deriveFont(1.0f * (float)Math.round(font.getSize2D() * (float)fontSizePercent / 100.0f));
        }
        return font;
    }

    private static Font translateFont(Font font, JComponent component) {
        float scaleFactor = UiUtil.getLookAndFeelEnhancer().getCustomScaleFactor();
        if (font.getSize() == 0) {
            return font.deriveFont((float)component.getFont().getSize());
        }
        if (scaleFactor == 1.0f) {
            return font;
        }
        return font.deriveFont((float)font.getSize() * scaleFactor);
    }
}

