/*
 * Decompiled with CFR 0.152.
 */
package com.ejt.internal.util;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class CommonBeanUtil {
    public static Object getPropertyValue(Object object, String propertyName) {
        if (object == null) {
            return null;
        }
        try {
            PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors();
            Method readMethod = CommonBeanUtil.findReadMethod(propertyName, propertyDescriptors);
            if (readMethod == null) {
                return null;
            }
            return readMethod.invoke(object, new Object[0]);
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getNestedPropertyValue(Object object, String[] nestedPropertyNames) {
        Object currentBean = object;
        for (String nestedPropertyName : nestedPropertyNames) {
            Object propertyValue = CommonBeanUtil.getPropertyValue(currentBean, nestedPropertyName);
            if (propertyValue == null) {
                throw new RuntimeException("Could not find property " + nestedPropertyName + " in bean " + currentBean + " for compound property " + String.join((CharSequence)".", nestedPropertyNames));
            }
            currentBean = propertyValue;
        }
        return currentBean;
    }

    protected static Method findReadMethod(String name, PropertyDescriptor[] properties) {
        for (PropertyDescriptor property : properties) {
            if (!property.getName().equals(name)) continue;
            return property.getReadMethod();
        }
        return null;
    }

    public static Object getPropertyValue(Object bean, PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null || bean == null) {
            return null;
        }
        Method readMethod = propertyDescriptor.getReadMethod();
        try {
            return readMethod.invoke(bean, (Object[])null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

